/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.recipe.flask.RecipePotionCycle;

public class PotionCycleRecipeSerializer<RECIPE extends RecipePotionCycle>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public PotionCycleRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        if (json.has("input") && GsonHelper.m_13885_((JsonObject)json, (String)"input")) {
            JsonArray mainArray = GsonHelper.m_13933_((JsonObject)json, (String)"input");
            for (JsonElement element : mainArray) {
                if (inputList.size() >= 5) break;
                if (element.isJsonArray()) {
                    element = element.getAsJsonArray();
                } else {
                    element.getAsJsonObject();
                }
                inputList.add(Ingredient.m_43917_((JsonElement)element));
            }
        }
        int numCycles = GsonHelper.m_13927_((JsonObject)json, (String)"count");
        int syphon = GsonHelper.m_13927_((JsonObject)json, (String)"syphon");
        int ticks = GsonHelper.m_13927_((JsonObject)json, (String)"ticks");
        int minimumTier = GsonHelper.m_13927_((JsonObject)json, (String)"upgradeLevel");
        return this.factory.create(recipeId, inputList, numCycles, syphon, ticks, minimumTier);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<Ingredient> input = new ArrayList<Ingredient>(size);
        for (int i = 0; i < size; ++i) {
            input.add(i, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        int syphon = buffer.readInt();
        int ticks = buffer.readInt();
        int minimumTier = buffer.readInt();
        int numCycles = buffer.readInt();
        return this.factory.create(recipeId, input, numCycles, syphon, ticks, minimumTier);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        ((RecipePotionCycle)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipePotionCycle> {
        public RECIPE create(ResourceLocation var1, List<Ingredient> var2, int var3, int var4, int var5, int var6);
    }
}

